<?php snippet('header') ?>

<?php snippet('intro') ?>

<?php 
// Get articles, filter by publish date, sort and paginate 'em
$items = $page->children()->listed()->filterBy('pub_date', '<=', date('Y-m-d'))->sortBy('pub_date', 'desc')->paginate(12); 
if($items && $items->count() > 0): ?>

<section class="sec-gen bg insights">
	<div class="container-med">
		<div class="list-cards">
			<?php foreach($items as $item): ?>
			<div class="list-card">
				<div class="list-card-wrap">
					<div class="list-card-img">
						<?php if($img = $item->featured_img()->toFile()): ?>
						<a href="<?= $item->url() ?>">
							<img src="<?= $img->crop(600,600)->url() ?>" alt="*">
						</a>
						<?php endif ?>
					</div>
					<div class="list-card-txt">
						<h2><a href="<?= $item->url() ?>"><?= $item->title() ?></a></h2>
						<?php e($item->pub_date()->isNotEmpty(), '<time>'. $item->pub_date()->toDate('F j, Y') .'</time>' ) ?>
						<p>
							<?php e($item->excerpt()->isNotEmpty(), $item->excerpt(). ' ') ?>
							<a href="<?= $item->url() ?>">Read Article</a>
						</p>
					</div>
				</div>
			</div>
			<?php endforeach ?>
		</div>
	</div>
</section>

<?php // Navigate through list of articles
if($items->pagination()->hasPages()): ?>
<div class="sec-gen bg-alt pagination" style="padding:48px 0;">
	<div class="container-med">
	  <p class="btns center">	  	
		  <?php if ($items->pagination()->hasPrevPage()): ?>
		  <a class="btn" href="<?= $items->pagination()->prevPageURL() ?>" title="Previous Page">
		  	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M7 18V6H9V18H7ZM11 12 17 6V18L11 12Z"></path></svg>
		  </a>
		  <?php endif ?>
		  <?php if ($items->pagination()->hasNextPage()): ?>
		  <a class="btn" href="<?= $items->pagination()->nextPageURL() ?>" title="Next Page">
		  	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M17 6 17 18H15L15 6 17 6ZM13 12 7 18V6L13 12Z"></path></svg>
		  </a>
		  <?php endif ?>
	  </p>
	</div>
</div>
<?php endif ?>

<?php // If no results...
else: ?>
<div class="sec-gen">
	<p class="center">Check back soon.</p>
</div>
<?php endif ?>

<?php snippet('footer') ?>