<?php 
// Get content for cards
$items = page('/types-of-living')->children()->listed();
if(!empty($items)): 
?>
<section class="sec-gen<?php e($block->tol_cards_bg()->toBool() === true, ' bg-alt', ' bg' ) ?>">
  <div class="container">
    
    <div class="sec-hd">
      <h2 class="rule">Types of Living</h2>
      <?php e($block->tol_cards_subhd()->isNotEmpty(), '<p class="callout">'. $block->tol_cards_subhd()->inline() .'</p>' ) ?>
    </div>

    <div class="card-grid">
      <?php foreach($items as $item): ?>
      <div class="card">
        <div class="card-wrap">
          <?php if($img = $item->intro_img()->toFile()): ?>
          <a href="<?= $item->url() ?>">
            <img src="<?= $img->crop(800,450)->url() ?>" alt="*">
          </a>
          <?php endif ?>
          <div class="card-text">
            <h3><?= $item->title() ?></h3>
            <?php e($item->intro_text()->isNotEmpty(), $item->intro_text() ) ?>
            <?php if($item->title()->isNotEmpty()): ?>
            <p><a href="<?= $item->url() ?>"><?php e($item->link_text()->isNotEmpty(), $item->link_text(), 'Learn More' ) ?></a></p>
            <?php endif ?>
          </div>
        </div>
      </div>
      <?php endforeach ?>
    </div>

  </div>
</section>
<?php endif ?>