<?php 
// get testimonials
$items = page('/testimonials')->testimonies()->toStructure(); 

// if results...
if($items && $items->count() > 0): 

// randomly choose under or over 300
$over300 = rand(0, 1);

$items = $items->filter(function($item) use ($over300) {
  $len = Str::length($item->testimony_text()->value());
  return $over300 ? $len >= 300 : $len < 300;
});

// shuffle, limit
$items = $items->shuffle()->limit(3); 
?>
<section class="sec-testimony dark-bg">
  <div class="container-med">
    <div class="quotes-icon"></div>
      <div class="testimonies glide">
        <div class="glide__track" data-glide-el="track">
          <div class="glide__slides">   

            <?php foreach($items as $item): ?>
            <!-- Slide -->
            <blockquote class="glide__slide">
              <div>
                <?php e($item->testimony_text()->isNotEmpty(), '<p class="quote">'. $item->testimony_text()->widont() .'</p>' ) ?>
                <?php if($item->testimony_name()->isNotEmpty() || $item->testimony_role()->isNotEmpty()): ?>
                <p class="cite">
                  <?php e($item->testimony_name()->isNotEmpty(), '<strong>'. $item->testimony_name() .'</strong>' ) ?>
                  <?php e($item->testimony_role()->isNotEmpty(), $item->testimony_role() ) ?>
                </p>
                <?php endif ?>
              </div>
            </blockquote>
            <?php endforeach ?>

          </div>
        </div>

        <!-- Controls -->
        <div class="glide__bullets" data-glide-el="controls[nav]">
          <?php $i=0; foreach($items as $item): ?>
          <button class="glide__bullet" data-glide-dir="=<?= $i ?>"></button>
          <?php $i++; endforeach ?>
        </div>

      </div>
    </div>
  </div>
</section>
<script>
  // https://glidejs.com/docs/options/
  new Glide('.glide').mount();
</script>
<?php endif; ?>