<?php 
// Get Floor Plans
$uid = uniqid(); // for unique gallery class
$imgs = $block->plans_cards_src()->split();
if($imgs && $imgs > 0): ?>
<section id="floorplans" class="sec-gen plans<?php e($block->plans_cards_bg()->toBool() === true, ' bg-alt', ' bg' ) ?>">
  <div class="container">
    <div class="sec-hd">
      <h2 class="rule">Floor Plans</h2>
      <?php e($page->plans_cards_subhd()->isNotEmpty(), '<p class="callout">'. $page->plans_cards_subhd()->inline() .'</p>' ) ?>
    </div>
    <div class="card-grid cols-4">
      
      <?php foreach($imgs as $img): ?>
      <?php if($img = page('/gallery')->image($img)): ?>
      <div class="card">
        <a 
          class="card-wrap glightbox" 
          href="<?= $img->resize(null,1080)->url() ?>"
          data-gallery="gallery<?= $uid ?>"
          <?php e($img->file_title()->isNotEmpty(), 'data-title="'. $img->file_title() .'"' ) ?>
          data-type="image">
          <img src="<?= $img->crop(800,450)->url() ?>" alt="*">
        
          <div class="card-text">
            <?php e($img->file_title()->isNotEmpty(), '<h3>'. $img->file_title() .'</h3>' ) ?>
            <?php e($img->caption()->isNotEmpty(), '<p>'. $img->caption() .'</p>' ) ?>
            <p><span class="text-link">See Details</span></p>
            </p>
          </div>
        </a>
      </div>
      <?php endif; endforeach ?>
    
    </div>
  </div>
</section>
<?php endif ?>
