<?php
return [
  'debug' => true,
  'panel' => [
    'install' => true
  ],
  'auth' => [
    'methods' => ['password', 'password-reset'],
    'challenge' => [
      'timeout' => 5 * 60, // 5 minutes
      'email' => [
        'from'     => 'info@weathervanesl.com',
        'subject'  => 'Password Reset - The Residence at Boyertown'
      ]
    ]
  ],
  'email' => [
    'transport' => [
      'type' => 'smtp',
      'host' => 'email-smtp.us-east-1.amazonaws.com',
      'port' => 587,
      'security' => true,
      'auth' => true,
      'username' => 'AKIAQO4YWJZGOSTON2EH',
      'password' => 'BLxNF73N6A9Gp4eH+IiNuInPaxc39MvrWmJYaZ3T4ExT',
    ]
  ],
  'routes' => [
    [
      'pattern' => '/process-form',
      'method' => 'POST',
      'action'  => function () {
        return new Page([
          'slug' => 'process-form',
          'template' => 'process-form'
        ]);
      }
    ],
    [
      'pattern' => 'testimonials',
      'action'  => function () {
        return go('error', 301);
      }
    ],
    [
      'pattern' => 'events/(:any)',
      'action'  => function ($slug) {
        return go('error/', 301);
      }
    ],
    // start 301 redirects to address old site
    [
      'pattern' => '/embrace-the-season-residence-at-village-greens',
      'action'  => function(){ return go('/types-of-living/independent', 301); }
    ],
    [
      'pattern' => '/personal-care/',
      'action'  => function(){ return go('/types-of-living/personal-care', 301); }
    ],
    [
      'pattern' => '/memory-care',
      'action'  => function(){ return go('/', 301); }
    ],
    [
      'pattern' => '/respite-care',
      'action'  => function(){ return go('/types-of-living/memory', 301); }
    ],
    [
      'pattern' => '/residence-at-village-greens/explore-our-community',
      'action'  => function(){ return go('/gallery', 301); }
    ],
    [
      'pattern' => '/blog/',
      'action'  => function(){ return go('/insight', 301); }
    ],
    [
      'pattern' => '/grand-opening-celebration-at-berks-countys-new-senior-living-community',
      'action'  => function(){ return go('/insight/grand-opening-celebration', 301); }
    ],
    [
      'pattern' => '/the-residence-at-village-greens-builds-upon-leadership-team-ahead-of-grand-opening',
      'action'  => function(){ return go('/insight/builds-upon-leadership-team-ahead-of-grand-opening', 301); }
    ],
    [
      'pattern' => '/golfers-paradise-senior-living-with-a-putting-green',
      'action'  => function(){ return go('/insight/golfers-paradise', 301); }
    ],
    [
      'pattern' => '/historical-haven-from-site-of-19th-century-mansion-to-modern-senior-living-community',
      'action'  => function(){ return go('/insight/historical-haven-from-site-of-19th-century-mansion', 301); }
    ],
    [
      'pattern' => '/the-residence-at-village-greens-prepares-for-grand-opening-with-move-in-commitments-from-throughout-the-region',
      'action'  => function(){ return go('/insight/grand-opening', 301); }
    ],
    [
      'pattern' => '/helping-seniors-a-true-passion-to-new-community-relations-director',
      'action'  => function(){ return go('/insight/helping-seniors-a-true-passion', 301); }
    ],
    [
      'pattern' => '/leadership-team-at-new-berks-county-senior-living-community-has-local-roots',
      'action'  => function(){ return go('/insight/leadership-team-local-roots', 301); }
    ],
    [
      'pattern' => '/now-open/',
      'action'  => function(){ return go('/insight/grand-opening-celebration', 301); }
    ],
    [
      'pattern' => '/residence-at-village-greens/events/',
      'action'  => function(){ return go('/events', 301); }
    ],
    // Generate site map
    [
      'pattern' => 'sitemap.xml',
      'action'  => function() {
          $pages = site()->pages()->index();
          $ignore = kirby()->option('sitemap.ignore', ['error']);
          $content = snippet('sitemap', compact('pages', 'ignore'), true);
          return new Kirby\Cms\Response($content, 'application/xml');
      }
    ],
    [
      'pattern' => 'sitemap',
      'action'  => function() {
        return go('sitemap.xml', 301);
      }
    ]
  ]
];